<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>PHP Newsletter | <?php echo e(trans('install.str.installation')); ?></title>

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Bootstrap Core CSS -->

    <?php echo Html::style('/css/bootstrap.min.css'); ?>


    <?php echo Html::style('/css/style.css'); ?>


    <?php echo Html::style('/css/vendor.css'); ?>


    <?php echo HTML::style('/css/install.css'); ?>


    <?php echo Html::style('/plugins/bootstrap-select/css/bootstrap-select.min.css'); ?>


    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">

    <?php echo Html::style('/plugins/fontawesome-free/css/all.min.css'); ?>


    <?php echo $__env->yieldContent('css'); ?>

    <script type="text/javascript">
        var SITE_URL = "<?php echo e(url('/')); ?>";
    </script>

</head>
<body>

<div class="container-fluid">

    <div class="row">
        <div class="col-md-6 offset-3">
            <div class="pull-right form-group">
                <select id="lang" class="selectpicker">
                    <option value="ru" <?php echo e(Config::get('app.locale') == 'ru' ? 'selected="selected"':''); ?>>Русский (Russian)</option>
                    <option value="en" <?php echo e(Config::get('app.locale') == 'en' ? 'selected="selected"':''); ?>>English</option>
                </select>
            </div>
        </div>

        <div class="col-md-6 offset-3 logo-wrapper">
            <img src="<?php echo e(url('/dist/img/logo.png')); ?>" alt="PHP Newsletter" class="logo">
        </div>
    </div>
    <div class="wizard col-md-6 offset-3">

        <?php echo $__env->yieldContent('content'); ?>

    </div>
</div>

<!-- jQuery -->
<?php echo Html::script('/plugins/jquery/jquery.min.js'); ?>


<!-- Bootstrap 4 -->
<?php echo Html::script('/plugins/bootstrap/js/bootstrap.bundle.min.js'); ?>


<?php echo Html::script('/plugins/bootstrap-select/js/bootstrap-select.min.js'); ?>


<?php echo $__env->yieldContent('js'); ?>

<script>

    $(document).ready(function () {
        $('.selectpicker').selectpicker();

        $('#lang').on('change', function () {
            let Lng = $(this).val();

            let request = $.ajax({
                url: '<?php echo e(route('install.ajax.action')); ?>',
                method: "POST",
                data: {
                    action: "change_lng",
                    locale: Lng,
                },
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                dataType: "json"
            });

            request.done(function (data) {
                if (data.result != null && data.result === true) {
                    location.reload();
                }
            });
        });
    });

</script>

</body>
</html>
<?php /**PATH /var/www/site1.local/www/phpnewsletter_7/resources/views/layouts/install.blade.php ENDPATH**/ ?>