<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied.');

class Pgb
{
    public static function getIP()
    {
        if (getenv("HTTP_CLIENT_IP") && strcasecmp(getenv("HTTP_CLIENT_IP"), "unknown"))
            $ip = getenv("HTTP_CLIENT_IP");
        elseif (getenv("HTTP_X_FORWARDED_FOR") && strcasecmp(getenv("HTTP_X_FORWARDED_FOR"), "unknown"))
            $ip = getenv("HTTP_X_FORWARDED_FOR");
        elseif (getenv("REMOTE_ADDR") && strcasecmp(getenv("REMOTE_ADDR"), "unknown"))
            $ip = getenv("REMOTE_ADDR");
        elseif (!empty($_SERVER['REMOTE_ADDR']) && strcasecmp($_SERVER['REMOTE_ADDR'], "unknown"))
            $ip = $_SERVER['REMOTE_ADDR'];
        else
            $ip = "unknown";

        return ($ip);
    }

    public static function emoticon($str)
    {
        $str = str_replace("[:))]", '<IMG border=0 src="templates/smile/icon_biggrin.gif">', $str);
        $str = str_replace("[:~]", '<IMG border=0 src="templates/smile/icon_confused.gif">', $str);
        $str = str_replace("[:)]", '<IMG border=0 src="templates/smile/icon_cool.gif">', $str);
        $str = str_replace("[:(|]", '<IMG border=0 src="templates/smile/icon_mad.gif">', $str);
        $str = str_replace("[:|]", '<IMG border=0 src="templates/smile/icon_eek.gif">', $str);
        $str = str_replace("[:(]", '<IMG border=0 src="templates/smile/icon_frown.gif">', $str);
        $str = str_replace("[:|)]", '<IMG border=0 src="templates/smile/icon_smile.gif">', $str);
        $str = str_replace("[:/]", '<IMG border=0 src="templates/smile/icon_wink.gif">', $str);
        $str = str_replace("[:()]", '<IMG border=0 src="templates/smile/icon_razz.gif">', $str);
        $str = str_replace("[:/~]", '<IMG border=0 src="templates/smile/icon_blush.gif">', $str);
        $str = str_replace("[:/(]", '<IMG border=0 src="templates/smile/icon_cray.gif">', $str);
        $str = str_replace("[:)(]", '<IMG border=0 src="templates/smile/icon_dance.gif">', $str);
        $str = str_replace("[:|_|]", '<IMG border=0 src="templates/smile/icon_drinks.gif">', $str);
        $str = str_replace("[:?]", '<IMG border=0 src="templates/smile/icon_fool.gif">', $str);
        $str = str_replace("[:)|]", '<IMG border=0 src="templates/smile/icon_good.gif">', $str);
        $str = str_replace("[:@@]", '<IMG border=0 src="templates/smile/icon_kiss_mini.gif">', $str);
        $str = str_replace("[:)-]", '<IMG border=0 src="templates/smile/icon_man_in_love.gif">', $str);
        $str = str_replace("[:-@]", '<IMG border=0 src="templates/smile/icon_rolleyes.gif">', $str);
        $str = str_replace("[:||]", '<IMG border=0 src="templates/smile/icon_scratch.gif">', $str);
        $str = str_replace("[:@|]", '<IMG border=0 src="templates/smile/icon_shok.gif">', $str);
        $str = str_replace("[:@(|)]", '<IMG border=0 src="templatessmile/icon_shout.gif">', $str);

        return $str;
    }

    public static function clearEmoticon($str)
    {
        $str = str_replace("[:))]", '', $str);
        $str = str_replace("[:~]", '', $str);
        $str = str_replace("[:)]", '', $str);
        $str = str_replace("[:(|]", '', $str);
        $str = str_replace("[:|]", '', $str);
        $str = str_replace("[:(]", '', $str);
        $str = str_replace("[:|)]", '', $str);
        $str = str_replace("[:/]", '', $str);
        $str = str_replace("[:()]", '', $str);
        $str = str_replace("[:/~]", '', $str);
        $str = str_replace("[:/(]", '', $str);
        $str = str_replace("[:)(]", '', $str);
        $str = str_replace("[:|_|]", '', $str);
        $str = str_replace("[:?]", '', $str);
        $str = str_replace("[:)|]", '', $str);
        $str = str_replace("[:@@]", '', $str);
        $str = str_replace("[:)-]", '', $str);
        $str = str_replace("[:-@]", '', $str);
        $str = str_replace("[:||]", '', $str);
        $str = str_replace("[:@|]", '', $str);
        $str = str_replace("[:@(|)]", '', $str);

        return $str;
    }

    public static function bbCodeConvert($msg)
    {
        $msg = nl2br($msg);
        $msg = str_replace("\n", " ", $msg);
        $msg = str_replace("\r", " ", $msg);
        $msg = str_replace("[b]", "<b>", $msg);
        $msg = str_replace("[/b]", "</b>", $msg);
        $msg = str_replace("[i]", "<i>", $msg);
        $msg = str_replace("[/i]", "</i>", $msg);
        $msg = str_replace("[u]", "<u>", $msg);
        $msg = str_replace("[/u]", "</u>", $msg);
        $msg = str_replace("[s]", "<s>", $msg);
        $msg = str_replace("[/s]", "</s>", $msg);
        $msg = str_replace("[p right]", "<p align=right>", $msg);
        $msg = str_replace("[p center]", "<p align=center>", $msg);
        $msg = str_replace("[p left]", "<p align=left>", $msg);
        $msg = str_replace("[p justify]", "<p align=justify>", $msg);
        $msg = str_replace("[/p]", "</p>", $msg);
        $msg = str_replace("[font", "<font", $msg);
        $msg = str_replace("[/font]", "</font>", $msg);

        $replace = "/\#\]/";
        $replacement = ">";
        return preg_replace($replace, $replacement, $msg);
    }

    public static function checkLengthText($text)
    {
        $lendescript = strlen($text);
        $templen = 0;
        $temp = strtok($text, " ");

        if (strlen($text) > 80) {
            while ($templen < $lendescript) {
                if (strlen($temp) > 80) {
                    return true;
                    break;
                } else {
                    $templen = $templen + strlen($temp) + 1;
                }

                $temp = strtok(" ");
            }
        }
    }

    public static function checkEmail($email)
    {
        if (preg_match("/^([a-z0-9_\.\-]{1,20})@([a-z0-9\.\-]{1,20})\.([a-z]{2,6})$/i", $email))
            return false;
        else
            return true;
    }

    public static function checkUrl($url)
    {
        if (!preg_match("/^(?:http\:\/\/)?[-0-9a-z_\.]+\.([a-z]{2,6})$/i", $url)){
            return false;
        } else {
            return true;
        }
    }
}