<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

//include template
core::requireEx('libs', "html_template/SeparateTemplate.php");
$tpl = SeparateTemplate::instance()->loadSourceFromFile(core::getTemplate() . core::getSetting('controller') . ".tpl");

$tpl->assign('BASE_URL', $_SERVER['SERVER_NAME'] . core::root());

$tpl->assign('TITLE_PAGE', core::getLanguage('title_page', 'index'));
$tpl->assign('TITLE', core::getLanguage('title', 'index'));

if ($data->checkBanIP(Pgb::getIP()) == false) {
    exit();
}

include_once core::pathTo('extra', 'top.php');

$tpl->assign('NUMBER_MSG', $data->getNumberMsg());
$tpl->assign('STR_NUMBER_MSG', core::getLanguage('str', 'number_msg'));
$tpl->assign('STR_ADD_COMMENT', core::getLanguage('str', 'add_comment'));

if (core::getSetting('number_post'))
    $pnumber = core::getSetting('number_post');
else
    $pnumber = 10;

$arr = $data->getCommnetsList(core::getSetting('order_pages') == 2 ? 'DESC' : '', 'show', Core_Array::getRequest('page'), $pnumber);

if ($arr) {
    foreach ($arr as $row) {
        $rowBlock = $tpl->fetch('row_comments');
        $rowBlock->assign('NAME', $row['name']);
        $rowBlock->assign('CITY', $row['city']);
        $rowBlock->assign('EMAIL', $row['email']);
        $rowBlock->assign('URL', $row['url']);
        $rowBlock->assign('TIME', $row['created']);
        $rowBlock->assign('MSG',  core::getSetting('show_smiles') == "yes" ? Pgb::emoticon($row['msg']) : Pgb::clearEmoticon($row['msg']));
        $rowBlock->assign('ADMIN', $row['admin']);
        $rowBlock->assign('STR_AUTHOR_CITY', core::getLanguage('str', 'author_city'));
        $rowBlock->assign('STR_AUTHOR_EMAIL', core::getLanguage('str', 'author_site'));
        $rowBlock->assign('STR_ADDED', core::getLanguage('str', 'added'));
        $rowBlock->assign('STR_ADMIN_MSG', core::getLanguage('str', 'admin_msg'));
        $tpl->assign('row_comments', $rowBlock);
    }
}

//pagination
$number = $data->getTotal();
$page = $data->getPageNumber();

if ($page != 1) {
    $pervpage = '<a href="./page_1">&lt;&lt;</a>';
    $perv = '<a href="./page_' . ($page - 1) . '">&lt;</a>';
}

if ($page != $number) {
    $nextpage = '<a href="./page_' . ($page + 1) . '">&gt;</a>';
    $next = '<a href="./page_' . $number . '">&gt;&gt;</a>';
}

if ($page - 2 > 0) $page2left = '<a href="./page_' . ($page - 2) . '">...' . ($page - 2) . '</a>';
if ($page - 1 > 0) $page1left = '<a href="./page_' . ($page - 1) . '">' .($page - 1) . '</a>';
if ($page + 2 <= $number) $page2right = '<a href="./page_' . ($page + 2) . '">' . ($page + 2) . '...</a>';
if ($page + 1 <= $number) $page1right = '<a href="./page_' . ($page + 1) . '">' . ($page + 1) . '</a>';

if ($number > 1) {
    $paginationBlock = $tpl->fetch('pagination');
    $paginationBlock->assign('STR_PNUMBER', core::getLanguage('str', 'pnumber'));
    $paginationBlock->assign('CURRENT_PAGE', '<a>' . $page . '</a>');
    $paginationBlock->assign('PAGE1RIGHT', isset($page1right) ? $page1right : '');
    $paginationBlock->assign('PAGE2RIGHT', isset($page2right) ? $page2right : '');
    $paginationBlock->assign('PAGE1LEFT', isset($page1left) ?  $page1left : '');
    $paginationBlock->assign('PAGE2LEFT', isset($page2left) ? $page2left : '');
    $paginationBlock->assign('PERVPAGE', isset($pervpage) ? $pervpage : '');
    $paginationBlock->assign('PERV', isset($perv) ? $perv : '');
    $paginationBlock->assign('NEXTPAGE', isset($nextpage) ? $nextpage : '');
    $paginationBlock->assign('NEXT', isset($next) ? $next : '');
    $paginationBlock->assign('PNUMBER', $pnumber);
    $tpl->assign('pagination', $paginationBlock);
}

//footer
include_once core::pathTo('extra', 'footer.php');

//display content
$tpl->display();