<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

Auth::authorization();

//include template
core::requireEx('libs', "html_template/SeparateTemplate.php");
$tpl = SeparateTemplate::instance()->loadSourceFromFile(core::getTemplate() . "admin/settings.tpl");

//menu
include_once core::pathTo('extra', 'menu.php');

$errors = array();

if (Core_Array::getRequest('action')) {
    $fields = Array();
    $fields['email'] = trim(Core_Array::getRequest('email'));
    $fields['send'] = Core_Array::getRequest('send') == 'on' ? "yes" : "no";;
    $fields['admin'] = Core_Array::getRequest('admin') == 'on' ? "yes" : "no";;
    $fields['number_post'] = (int)Core_Array::getRequest('number_post');
    $fields['show_captcha'] = Core_Array::getRequest('show_captcha') == 'on' ? "yes" : "no";;
    $fields['show_smiles'] = Core_Array::getRequest('show_smiles') == 'on' ? "yes" : "no";;
    $fields['msg_len'] = (int)Core_Array::getRequest('msg_len');
    $fields['order_pages'] = Core_Array::getRequest('order_pages');
    $fields['show_email'] = Core_Array::getRequest('show_email') == 'on' ? "yes" : "no";
    $fields['show_site'] = Core_Array::getRequest('show_site') == 'on' ? "yes" : "no";
    $fields['show_city'] = Core_Array::getRequest('show_city') == 'on' ? "yes" : "no";
    $fields['language'] = trim(Core_Array::getRequest('language'));

    if ($data->updateSettings($fields)) {
        header('Location: ./settings');
        exit;
    } else $errors[] = core::getLanguage('error', 'web_apps_error');
}

$tpl->assign('TITLE_PAGE', core::getLanguage('admin_title_page', 'settings'));
$tpl->assign('TITLE', core::getLanguage('admin_title', 'settings'));

if (isset($success_msg)) {
    $tpl->assign('MSG_ALERT', $success_msg);
}

if (!empty($errors)) {
    $errorBlock = $tpl->fetch('show_errors');
    $errorBlock->assign('STR_IDENTIFIED_FOLLOWING_ERRORS', core::getLanguage('str', 'identified_following_errors'));

    foreach($errors as $row) {
        $rowBlock = $errorBlock->fetch('row');
        $rowBlock->assign('ERROR', $row);
        $errorBlock->assign('row', $rowBlock);
    }

    $tpl->assign('show_errors', $errorBlock);
}

//form
$tpl->assign('STR_GO_BACK', core::getLanguage('str', 'go_back'));
$tpl->assign('STR_LANGUAGE', core::getLanguage('str', 'language'));
$tpl->assign('STR_LANGUAGE_EN', core::getLanguage('str', 'language_en'));
$tpl->assign('STR_LANGUAGE_RU', core::getLanguage('str', 'language_ru'));
$tpl->assign('STR_BY_INCREACE', core::getLanguage('str', 'by_increace'));
$tpl->assign('STR_BY_DECREASE', core::getLanguage('str', 'by_decrease'));
$tpl->assign('STR_ADMIN_EMAIL', core::getLanguage('str', 'admin_email'));
$tpl->assign('STR_SEND_NOTIFICATION', core::getLanguage('str', 'send_notification'));
$tpl->assign('STR_NUMBER_CHARS_IN_MSG', core::getLanguage('str', 'number_chars_in_msg'));
$tpl->assign('STR_NUMBER_OF_COMMENTS', core::getLanguage('str', 'number_of_comments'));
$tpl->assign('STR_HOW_TO_SORT_MESSAGE', core::getLanguage('str', 'how_to_sort_message'));
$tpl->assign('STR_ADD_NEW_MESSAGES_TO_MODERATION', core::getLanguage('str', 'add_new_messages_to_moderation'));
$tpl->assign('STR_NEW_MESSAGE_NOTIFY', core::getLanguage('str', 'new_message_notify'));
$tpl->assign('STR_ASK_SECURITY_CODE', core::getLanguage('str', 'ask_security_code'));
$tpl->assign('STR_SHOW_SMILES', core::getLanguage('str', 'show_smiles'));
$tpl->assign('STR_SHOW_FIELD_EMAIL',core::getLanguage('str', 'show_field_email'));
$tpl->assign('STR_SHOW_FIELD_CITY', core::getLanguage('str', 'show_field_city'));
$tpl->assign('STR_SHOW_FIELD_WEBSITE', core::getLanguage('str', 'show_field_website'));
$tpl->assign('BUTTON_APPLY', core::getLanguage('button', 'apply'));

//value
$tpl->assign('ACTION', $_SERVER['REQUEST_URI']);
$tpl->assign('LANGUAGE', core::getSetting('language'));
$tpl->assign('EMAIL', core::getSetting('email'));
$tpl->assign('MSG_LEN', core::getSetting('msg_len'));
$tpl->assign('NUMBER_POST', core::getSetting('number_post'));
$tpl->assign('ORDER_PAGES', core::getSetting('order_pages'));
$tpl->assign('ADMIN', core::getSetting('admin'));
$tpl->assign('SEND', core::getSetting('send'));
$tpl->assign('SHOW_CAPTCHA', core::getSetting('show_captcha'));
$tpl->assign('SHOW_SMILES', core::getSetting('show_smiles'));
$tpl->assign('SHOW_EMAIL', core::getSetting('show_email'));
$tpl->assign('SHOW_CITY', core::getSetting('show_city'));
$tpl->assign('SHOW_SITE', core::getSetting('show_site'));

// footer
include_once core::pathTo('extra', 'footer.php');

//display content
$tpl->display();