<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

Auth::authorization();

//include template
core::requireEx('libs', "html_template/SeparateTemplate.php");
$tpl = SeparateTemplate::instance()->loadSourceFromFile(core::getTemplate() . "admin/edit.tpl");

$tpl->assign('TITLE_PAGE', core::getLanguage('admin_title_page', 'edit'));
$tpl->assign('TITLE', core::getLanguage('admin_title', 'edit'));

if ($data->checkCommentExist(Core_Array::getRequest('id')) == false) {
    throw new Exception404('Page not found!');
}

if (Core_Array::getRequest('action')) {
    $fields = array();
    $fields['msg'] = trim(Core_Array::getPost('msg'));
    $fields['admin'] = trim(Core_Array::getPost('admin'));

    $errors = array();

    if ($data->editComment($fields, Core_Array::getRequest('id'))) {
        header('Location: http://' . $_SERVER['SERVER_NAME'] . core::root() . '/admin');
        exit;
    } else {
        $errors[] = core::getLanguage('error', 'web_apps_error');
    }
}

if (!empty($errors)) {
    $errorBlock = $tpl->fetch('show_errors');
    $errorBlock->assign('STR_IDENTIFIED_FOLLOWING_ERRORS', core::getLanguage('str', 'identified_following_errors'));

    foreach($errors as $row) {
        $rowBlock = $errorBlock->fetch('row');
        $rowBlock->assign('ERROR', $row);
        $errorBlock->assign('row', $rowBlock);
    }

    $tpl->assign('show_errors', $errorBlock);
}

//menu
include_once core::pathTo('extra', 'menu.php');

$row = $data->getCommentInfo(Core_Array::getRequest('id'));

//form
$tpl->assign('STR_RETURN_BACK', core::getLanguage('str', 'go_back'));
$tpl->assign('STR_MSG', core::getLanguage('str', 'msg'));
$tpl->assign('STR_ADMIN', core::getLanguage('str', 'admin'));
$tpl->assign('BUTTON', core::getLanguage('button', 'edit'));

//value
$tpl->assign('ACTION', $_SERVER['REQUEST_URI']);
$tpl->assign('ID', $row['id']);
$tpl->assign('MSG', Core_Array::getPost('msg') ? Core_Array::getPost('msg') : $row['msg']);
$tpl->assign('ADMIN', Core_Array::getPost('admin') ? Core_Array::getPost('admin') : $row['admin']);

// footer
include_once core::pathTo('extra', 'footer.php');

//display content
$tpl->display();