<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

Auth::authorization();

//include template
core::requireEx('libs', "html_template/SeparateTemplate.php");
$tpl = SeparateTemplate::instance()->loadSourceFromFile(core::getTemplate() . "admin/blackip.tpl");

$tpl->assign('TITLE_PAGE', core::getLanguage('admin_title_page', 'blackip'));
$tpl->assign('TITLE', core::getLanguage('admin_title', 'blackip'));

if (Core_Array::getRequest('edit') && $data->checkIpExist(Core_Array::getRequest('edit')) == false) {
    throw new Exception404('Page not found!');
}

//menu
include_once core::pathTo('extra', 'menu.php');

$tpl->assign('STR_COMMENT', core::getLanguage('str', 'comment'));
$tpl->assign('STR_ACTION', core::getLanguage('str', 'action'));

$errors = array();

if (Core_Array::getRequest('action')) {
    switch($_REQUEST['action']){
        case 'edit':
            $ip = trim(Core_Array::getPost('ip'));
            $comment = trim(Core_Array::getPost('comment'));

            if (empty($ip)) $errors[] = core::getLanguage('error', 'enter_ip');
            if (empty($errors)) {
                $fields = array();
                $fields['ip'] = $ip;
                $fields['comment'] = $comment;

                if ($data->editBlackIp($fields, Core_Array::getPost('id'))) {
                    header('Location: ./');
                    exit;
                } else {
                    $errors[] = core::getLanguage('error', 'web_apps_error');
                }
            }

            break;

        case 'remove':
            if ($data->removeIp(Core_Array::getGet('id'))) {
                header('Location: ./');
                exit;
            } else {
                $errors[] = core::getLanguage('error', 'web_apps_error');
            }

            break;
    }
}

if (isset($success_msg)) {
    $tpl->assign('MSG_ALERT', $success_msg);
}

if (!empty($errors)) {
    $errorBlock = $tpl->fetch('show_errors');
    $errorBlock->assign('STR_IDENTIFIED_FOLLOWING_ERRORS', core::getLanguage('str', 'identified_following_errors'));

    foreach($errors as $row) {
        $rowBlock = $errorBlock->fetch('row');
        $rowBlock->assign('ERROR', $row);
        $errorBlock->assign('row', $rowBlock);
    }

    $tpl->assign('show_errors', $errorBlock);
}

if (empty($_GET['edit'])) {
    foreach($data->getBlackListIp() as $row) {
        $rowBlock = $tpl->fetch('row_blackip_list');
        $rowBlock->assign('ID', $row['id']);
        $rowBlock->assign('IP', $row['ip']);
        $rowBlock->assign('COMMENT', $row['comment']);
        $rowBlock->assign('STR_EDIT', core::getLanguage('str', 'edit'));
        $rowBlock->assign('STR_REMOVE', core::getLanguage('str', 'remove'));
        $tpl->assign('row_blackip_list', $rowBlock);
    }

} else {
    $row = $data->getBlackIpInfo(Core_Array::getRequest('edit'));
	$tpl->assign('TASK', 'edit');
    $tpl->assign('EDIT', $_GET['edit']);
    $tpl->assign('ACTION', $_SERVER['REQUEST_URI']);
    $tpl->assign('STR_IP', core::getLanguage('str', 'ip'));
    $tpl->assign('IP', Core_Array::getPost('ip') ? $_POST['ip'] : $row['ip']);
    $tpl->assign('COMMENT', Core_Array::getPost('comment') ? $_POST['comment'] : $row['comment']);
    $tpl->assign('BUTTON', core::getLanguage('button', 'edit'));
}

$tpl->assign('STR_ADD_TO_BLACK', core::getLanguage('str', 'add_to_blackip'));
$tpl->assign('STR_RETURN_BACK', core::getLanguage('str', 'go_back'));

// footer
include_once core::pathTo('extra', 'footer.php');

//display content
$tpl->display();