<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

Auth::authorization();

//include template
core::requireEx('libs', "html_template/SeparateTemplate.php");
$tpl = SeparateTemplate::instance()->loadSourceFromFile(core::getTemplate() . "admin/add_blackip.tpl");

$errors = array();

if (Core_Array::getRequest('action')) {
    $ip = trim(Core_Array::getPost('ip'));
    $comment = trim(Core_Array::getPost('comment'));

    if (empty($ip)) $errors[] = core::getLanguage('error', 'enter_ip');
    if (empty($errors)) {
        $fields = array();
        $fields['id'] = 0;
        $fields['ip'] = $ip;
        $fields['comment'] = $comment;

        if ($data->addBlack($fields)) {
            header("Location: ./blackip");
            exit;
        } else {
            $errors[] = core::getLanguage('error', 'web_apps_error');
        }
    }
}

$tpl->assign('TITLE_PAGE', core::getLanguage('admin_title_page', 'add_blackip'));
$tpl->assign('TITLE', core::getLanguage('admin_title', 'add_blackip'));

if (isset($success_msg)) {
    $tpl->assign('MSG_ALERT', $success_msg);
}

if (!empty($errors)) {
    $errorBlock = $tpl->fetch('show_errors');
    $errorBlock->assign('STR_IDENTIFIED_FOLLOWING_ERRORS', core::getLanguage('str', 'identified_following_errors'));

    foreach($errors as $row) {
        $rowBlock = $errorBlock->fetch('row');
        $rowBlock->assign('ERROR', $row);
        $errorBlock->assign('row', $rowBlock);
    }

    $tpl->assign('show_errors', $errorBlock);
}

//menu
include_once core::pathTo('extra', 'menu.php');

//form
$tpl->assign('TASK', 'add');
$tpl->assign('ACTION', $_SERVER['REQUEST_URI']);
$tpl->assign('STR_RETURN_BACK', core::getLanguage('str', 'go_back'));
$tpl->assign('STR_IP', core::getLanguage('str', 'ip'));
$tpl->assign('STR_COMMENT', core::getLanguage('str', 'comment'));
$tpl->assign('BUTTON', core::getLanguage('button', 'add'));

//value
$tpl->assign('IP', Core_Array::getPost('ip'));
$tpl->assign('COMMENT', Core_Array::getPost('comment'));

// footer
include_once core::pathTo('extra', 'footer.php');

//display content
$tpl->display();