<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

session_start();

//include template
core::requireEx('libs', "html_template/SeparateTemplate.php");
$tpl = SeparateTemplate::instance()->loadSourceFromFile(core::getTemplate() . core::getSetting('controller') . ".tpl");

$tpl->assign('BASE_URL', $_SERVER['SERVER_NAME'] . core::root());

$tpl->assign('TITLE_PAGE', core::getLanguage('title_page', 'add'));
$tpl->assign('TITLE', core::getLanguage('title', 'add'));

if ($data->checkBanIP(Pgb::getIP()) == false) {
    exit();
}

$errors = array();

if (Core_Array::getRequest('action')) {
    $msg = stripslashes(htmlspecialchars(trim(Core_Array::getPost('msg'))));
    $name = stripslashes(htmlspecialchars(trim(Core_Array::getPost('name'))));
    $email = strtolower(trim(Core_Array::getPost('email')));
    $city = stripslashes(htmlspecialchars(trim(Core_Array::getPost('city'))));
    $url = strtolower(trim(Core_Array::getPost('url')));
    $captcha = trim(Core_Array::getRequest('captcha'));

    if (core::getSetting('show_email') == 'no') { $email = null; }
    if (core::getSetting('show_city') == 'no') { $city = null; }
    if (core::getSetting('show_site') == 'no') { $url = null; }

    if (!empty($url)){
        if ((substr($url, 0, 7)) == "http://") { $url = str_replace('http://', '', $url); }
    }

    if (!empty($email) && Pgb::checkEmail($email) == false) {
        $errors[] = core::getLanguage('error', 'wrong_email');
    }

    if (!empty($url) && Pgb::checkUrl($url) == false) {
        $errors[] = core::getLanguage('error', 'wrong_url');
    }

    if (!empty($msg) && Pgb::checkLengthText($msg) == true) {
        $errors[] = core::getLanguage('error', 'too_long_msg');

        if (strlen($msg) > core::getSetting('msg_len')) {
            $errors[] = str_replace('%MSG_LEN%', core::getSetting('msg_len'), core::getLanguage('error', 'number_chars'));
        }
    }

    if (core::getSetting('show_captcha') == 'yes' && !empty($captcha)) {
        if (empty($_SESSION['captcha']) || strtolower($captcha) != $_SESSION['captcha']) {
            $error = core::getLanguage('error', 'invalid_captcha');
        }

        unset($_SESSION['captcha']);
    }

    if (empty($name)) {
        $errors[] = core::getLanguage('error', 'enter_your_name');
    }

    if (empty($msg)) {
        $errors[] = core::getLanguage('error', 'enter_msg');
    }

    if (core::getSetting('show_captcha') == 'yes' && empty($captcha)) {
        $errors[] = core::getLanguage('error', 'enter_captcha');
    }

    if (empty($errors)) {
        $msg = Pgb::bbCodeConvert($msg);

        $fields = Array();
        $fields['id'] = 0;
        $fields['name'] = $name;
        $fields['msg'] = $msg;
        $fields['city'] = $city;
        $fields['email'] = $email;
        $fields['url'] = $url;
        $fields['ip'] = Pgb::getIP();
        $fields['created_at'] = date("Y-m-d H:i:s");
        $fields['hide'] = core::getSetting('admin') == "yes" ? "hide" : "show";

        if ($data->addComment($fields)) {

            unset($_POST);
            if (core::getSetting('send') == "yes") {
                $data->sendNotice($name, $msg);
            }

            $success_msg = core::getSetting('admin') == "yes" ? core::getLanguage('msg', 'message_is_added_to_moderation') : core::getLanguage('msg', 'message_is_added');

        } else {
            $errors[] = core::getLanguage('error', 'web_apps_error');
        }
    }
}

$tpl->assign('SHOW_EMAIL', core::getSetting('show_email'));
$tpl->assign('SHOW_CITY', core::getSetting('show_city'));
$tpl->assign('SHOW_SITE', core::getSetting('show_site'));
$tpl->assign('SHOW_SMILES', core::getSetting('show_smiles'));
$tpl->assign('SHOW_CAPTCHA', core::getSetting('show_captcha'));

//errors
if (!empty($errors)) {
    $errorBlock = $tpl->fetch('show_errors');
    $errorBlock->assign('STR_IDENTIFIED_FOLLOWING_ERRORS', core::getLanguage('str', 'identified_following_errors'));

    foreach($errors as $row) {
        $rowBlock = $errorBlock->fetch('row');
        $rowBlock->assign('ERROR', $row);
        $errorBlock->assign('row', $rowBlock);
    }

    $tpl->assign('show_errors', $errorBlock);
}

//alert
if (isset($success_msg)) {
    $tpl->assign('MSG_ALERT', $success_msg);
}

//form
$tpl->assign('STR_RETURN_BACK', core::getLanguage('str', 'return_back'));
$tpl->assign('STR_REQUIRED_FIELDS', core::getLanguage('str', 'required_fields'));
$tpl->assign('STR_SECURITY_ENTER_CODE', core::getLanguage('str', 'security_enter_code'));
$tpl->assign('STR_NAME', core::getLanguage('str', 'name'));
$tpl->assign('STR_EMAIL', core::getLanguage('str', 'email'));
$tpl->assign('STR_CITY', core::getLanguage('str', 'city'));
$tpl->assign('STR_URL', core::getLanguage('str', 'url'));
$tpl->assign('STR_BOLD', core::getLanguage('str', 'bold'));
$tpl->assign('STR_ITALIC', core::getLanguage('str', 'italic'));
$tpl->assign('STR_UNDERLINE', core::getLanguage('str', 'underline'));
$tpl->assign('STR_STRIKE', core::getLanguage('str', 'strike'));
$tpl->assign('STR_RIGHT', core::getLanguage('str', 'right'));
$tpl->assign('STR_CENTER', core::getLanguage('str', 'center'));
$tpl->assign('STR_LEFT', core::getLanguage('str', 'left'));
$tpl->assign('STR_JUSTIFY', core::getLanguage('str', 'justify'));
$tpl->assign('STR_SIZE', core::getLanguage('str', 'size'));
$tpl->assign('STR_MSG', core::getLanguage('str', 'msg'));
$tpl->assign('STR_FONT', core::getLanguage('str', 'font'));
$tpl->assign('STR_COLOR', core::getLanguage('str', 'color'));
$tpl->assign('STR_CAPTCHA', core::getLanguage('str', 'captcha'));
$tpl->assign('BUTTON_ADD', core::getLanguage('button', 'add'));
$tpl->assign('BUTTON_RESET', core::getLanguage('button', 'reset'));
$tpl->assign('STR_CAPTCHA_HINT', core::getLanguage('str', 'captcha_hint'));
$tpl->assign('STR_SECURITY_ENTER_CODE', core::getLanguage('str', 'security_enter_code'));


//value
$tpl->assign('ACTION', $_SERVER['REQUEST_URI']);
$tpl->assign('NAME', Core_Array::getPost('name'));
$tpl->assign('EMAIL', Core_Array::getPost('email'));
$tpl->assign('CITY', Core_Array::getPost('city'));
$tpl->assign('URL', Core_Array::getPost('url'));
$tpl->assign('MSG', Core_Array::getPost('msg'));

//display content
$tpl->display();