<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

class Model_index extends Model
{
    public function getCommnetsList($order = "DESC", $hide = 'all', $page, $pnumber = 10)
    {
        core::database()->tablename = core::database()->getTableName('messages');
        core::database()->parameters = "*, DATE_FORMAT(created_at,'%d.%m.%Y %H:%i') AS created";

        if ($hide != 'all') {
            core::database()->where = "WHERE hide='" . $hide . "'";
        }

        core::database()->order = "ORDER BY id " . $order . "";
        core::database()->pnumber = $pnumber;
        core::database()->page = $page;
        return core::database()->get_page();
    }

    public function getTotal()
    {
        core::database()->tablename = core::database()->getTableName('messages');
        return $number = intval((core::database()->get_total() - 1) / core::database()->pnumber) + 1;
    }

    public function getPageNumber()
    {
        return core::database()->page;
    }

    public function getNumberMsg()
    {
        $query = "SELECT * FROM " . core::database()->getTableName('messages') . "
						WHERE hide='show'";

        $result = core::database()->querySQL($query);

        return core::database()->getRecordCount($result);
    }

    public function showComment($id)
    {
        if (is_numeric($id)) {
            $fields = array('hide' => 'show');
            return core::database()->update($fields, core::database()->getTableName('messages'), "id=" . $id);
        }
    }

    public function removeComment($id)
    {
        if (is_numeric($id)) {
            return core::database()->delete(core::database()->getTableName('messages'), "id=" . $id);
        }
    }

    public function checkBanIP($ip)
    {
        $query = "SELECT * FROM " . core::database()->getTableName('ip');
        $result = core::database()->querySQL($query);
        $check = true;

        foreach (core::database()->getColumnArray($result) as $row) {
            if (preg_match("!".preg_quote($row['ip'])."!", $ip)){
                $check = false;
                break;
            }
        }

        return $check;
    }
}