<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied.');

Error_Reporting(1); // set error reporting level
define("DEBUG", 0);

define("VERSION", '3.0.1');

$cmspaths = array(
    'core' => 'sys/core',
    'engine' => 'sys/engine', // Engines AUTOLOAD folder
    'config' => 'config', // Config
    'templates' => 'templates', // templates
    'controllers' => 'app/controllers', // controllers
	'libs' => 'vendor', // libraries
    'models' => 'app/models',
    'views' => 'app/views',
	'extra' => 'app/snippets'
);

require_once SYS_ROOT . $cmspaths['config'] . '/config_db.php';
require_once SYS_ROOT . $cmspaths['core'] . '/core.php';
core::init($cmspaths);
core::$db = new DB($ConfigDB);

// get settings
if (!is_array(core::getSetting())) {
    $query = "SELECT * FROM " . core::database()->getTableName('settings');
    $result = core::database()->querySQL($query);
    core::addSetting(core::database()->getRow($result));
}

// get language
$lang_file = core::pathTo('templates', 'language/');
$lang_file .= ((core::getSetting("language")) ? core::getSetting("language") . ".php" : "en.php");

if (file_exists($lang_file)) {
    include $lang_file;
    core::addLanguage($language);
} else {
    exit('ERROR: Language file can not load!');
}

core::setTemplate("assets/");