<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

Auth::authorization();

//include template
core::requireEx('libs', "html_template/SeparateTemplate.php");
$tpl = SeparateTemplate::instance()->loadSourceFromFile(core::getTemplate() . "admin/index.tpl");

$tpl->assign('TITLE_PAGE', core::getLanguage('admin_title_page', 'index'));
$tpl->assign('TITLE', core::getLanguage('admin_title', 'index'));

$errors = array();

if (Core_Array::getRequest('action')) {
    switch($_REQUEST['action']) {
        case 'show':

            if ($data->showComment(Core_Array::getGet('id'))){
                header('Location: ' . $_SERVER['HTTP_REFERER'] . '');
                exit;
            } else {
                $errors[] = core::getLanguage('error', 'web_apps_error');
            }

            break;

        case 'remove':

            if ($data->removeComment(Core_Array::getGet('id'))) {
                header('Location: ' . $_SERVER['HTTP_REFERER'] . '');
                exit;
            } else {
                $errors[] = core::getLanguage('error', 'web_apps_error');
            }

            break;
    }
}

//menu
include_once core::pathTo('extra', 'menu.php');

if (core::getSetting('number_post'))
    $pnumber = core::getSetting('number_post');
else
    $pnumber = 10;

$arr = $data->getCommnetsList(core::getSetting('order_pages') == 2 ? 'DESC' : '', 'all', Core_Array::getRequest('page'), $pnumber);

if ($arr) {
    foreach ($arr as $row) {
        if (core::getSetting('smile') == "yes") {
            $row['msg'] = Pgb::emoticon($row['msg']);
        } else {
            $row['msg'] = Pgb::emoticon($row['msg']);
        }

        $rowBlock = $tpl->fetch('row_comment');
        $rowBlock->assign('ID', $row['id']);
        $rowBlock->assign('NAME', $row['name']);
        $rowBlock->assign('EMAIL', $row['email']);
        $rowBlock->assign('URL', $row['url']);
        $rowBlock->assign('CITY', $row['city']);
        $rowBlock->assign('MSG', $row['msg']);
        $rowBlock->assign('ADMIN', $row['admin']);
        $rowBlock->assign('TIME', $row['created']);
        $rowBlock->assign('IP', $row['ip']);
        $rowBlock->assign('HIDE', $row['hide']);
        $rowBlock->assign('STR_CITY', core::getLanguage('str', 'city'));
        $rowBlock->assign('STR_EMAIL', core::getLanguage('str', 'email'));
        $rowBlock->assign('STR_SITE', core::getLanguage('str', 'site'));
        $rowBlock->assign('STR_EDIT', core::getLanguage('str', 'edit'));
        $rowBlock->assign('STR_SHOW', core::getLanguage('str', 'show'));
        $rowBlock->assign('STR_REMOVE', core::getLanguage('str', 'remove'));
        $rowBlock->assign('STR_ADMIN_MSG', core::getLanguage('str', 'admin_msg'));
        $rowBlock->assign('STR_ADDED', core::getLanguage('str', 'added'));
        $rowBlock->assign('STR_AUTHOR_MSG', core::getLanguage('str', 'author_msg'));
        $tpl->assign('row_comment', $rowBlock);
    }
}

//pagination
$number = $data->getTotal();
$page = $data->getPageNumber();

if ($page != 1) {
    $pervpage = '<a href="./admin/page_1">&lt;&lt;</a>';
    $perv = '<a href="./admin/page_' . ($page - 1) . '">&lt;</a>';
}

if ($page != $number) {
    $nextpage = '<a href="./admin/page_' . ($page + 1) . '">&gt;</a>';
    $next = '<a href="./admin/page_' . $number . '">&gt;&gt;</a>';
}

if ($page - 2 > 0) $page2left = '<a href="./admin/page_' . ($page - 2) . '">...' . ($page - 2) . '</a>';
if ($page - 1 > 0) $page1left = '<a href="./admin/page_' . ($page - 1) . '">' .($page - 1) . '</a>';
if ($page + 2 <= $number) $page2right = '<a href="./admin/page_' . ($page + 2) . '">' . ($page + 2) . '...</a>';
if ($page + 1 <= $number) $page1right = '<a href="./admin/page_' . ($page + 1) . '">' . ($page + 1) . '</a>';

if ($number > 1) {
    $paginationBlock = $tpl->fetch('pagination');
    $paginationBlock->assign('STR_PNUMBER', core::getLanguage('str', 'pnumber'));
    $paginationBlock->assign('CURRENT_PAGE', '<a>' . $page . '</a>');
    $paginationBlock->assign('PAGE1RIGHT', isset($page1right) ? $page1right : '');
    $paginationBlock->assign('PAGE2RIGHT', isset($page2right) ? $page2right : '');
    $paginationBlock->assign('PAGE1LEFT', isset($page1left) ?  $page1left : '');
    $paginationBlock->assign('PAGE2LEFT', isset($page2left) ? $page2left : '');
    $paginationBlock->assign('PERVPAGE', isset($pervpage) ? $pervpage : '');
    $paginationBlock->assign('PERV', isset($perv) ? $perv : '');
    $paginationBlock->assign('NEXTPAGE', isset($nextpage) ? $nextpage : '');
    $paginationBlock->assign('NEXT', isset($next) ? $next : '');
    $paginationBlock->assign('PNUMBER', $pnumber);
    $tpl->assign('pagination', $paginationBlock);
}

// footer
include_once core::pathTo('extra', 'footer.php');

//display content
$tpl->display();