<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

Auth::authorization();

//include template
core::requireEx('libs', "html_template/SeparateTemplate.php");
$tpl = SeparateTemplate::instance()->loadSourceFromFile(core::getTemplate() . "admin/change_password.tpl");

$errors = array();

if (Core_Array::getRequest('action')) {
    $current_password = trim(Core_Array::getPost('current_password'));
    $password = trim(Core_Array::getPost('password'));
    $password_again = trim(Core_Array::getPost('password_again'));

    if (!$current_password) {
        $errors[] = core::getLanguage('error', 'msg_error_enter_current_password');
    }

    if (!$password) {
        $errors[] = core::getLanguage('error', 'msg_error_password_isnt_entered');
    }

    if (!$password_again) {
        $errors[] = core::getLanguage('error', 'msg_error_reenter_password');
    }

    if ($password && $password_again && $password != $password_again){
        $errors[] = core::getLanguage('error', 'msg_error_passwords_dont_match');
    }

    if ($current_password) {
        $current_password = md5($current_password);

        if (Auth::getCurrentHash() != $current_password){
            $errors[] = core::getLanguage('error', 'msg_error_current_password');
        }
    }

    if (empty($errors)) {
        if ($data->changePassword(md5($password))) {
            $success_msg = core::getLanguage('msg', 'password_has_been_changed');
        } else {
            $errors[] = core::getLanguage('error', 'change_password');
        }
    }
}

$tpl->assign('TITLE_PAGE', core::getLanguage('admin_title_page', 'change_password'));
$tpl->assign('TITLE', core::getLanguage('admin_title', 'change_password'));

if (isset($success_msg)) {
    $tpl->assign('MSG_ALERT', $success_msg);
}

if (!empty($errors)) {
    $errorBlock = $tpl->fetch('show_errors');
    $errorBlock->assign('STR_IDENTIFIED_FOLLOWING_ERRORS', core::getLanguage('str', 'identified_following_errors'));

    foreach($errors as $row) {
        $rowBlock = $errorBlock->fetch('row');
        $rowBlock->assign('ERROR', $row);
        $errorBlock->assign('row', $rowBlock);
    }

    $tpl->assign('show_errors', $errorBlock);
}

//menu
include_once core::pathTo('extra', 'menu.php');

//form
$tpl->assign('STR_GO_BACK', core::getLanguage('str', 'go_back'));
$tpl->assign('STR_CURRENT_PASSWORD', core::getLanguage('str', 'current_password'));
$tpl->assign('STR_NEW_PASSWORD', core::getLanguage('str', 'new_password'));
$tpl->assign('STR_AGAIN_PASSWORD', core::getLanguage('str', 'again_password'));
$tpl->assign('BUTTON_CHANGE', core::getLanguage('button', 'update'));
$tpl->assign('STR_IDENTIFIED_FOLLOWING_ERRORS', core::getLanguage('str', 'identified_following_errors'));

// footer
include_once core::pathTo('extra', 'footer.php');

//display content
$tpl->display();