<?php

/********************************************
 * PHP Guestbook 3.0.1 beta
 * Copyright (c) 2007-2016 Alexander Yanitsky
 * Website: http://janicky.com
 * E-mail: janickiy@mail.ru
 * Skype: janickiy
 ********************************************/

defined('GUESTBOOK') || exit('GUESTBOOK: access denied!');

class Model_add extends Model
{
    public function addComment($fields)
    {
        return core::database()->insert($fields, core::database()->getTableName('messages'));
    }

    public function sendNotice($name, $msg)
    {
        core::requireEx('libs', "PHPMailer/class.phpmailer.php");

        $message = "" . str_replace('%SITENAME%', $_SERVER["SERVER_NAME"], core::getLanguage('error', 'added_new_comment_in_guestbook')) . "\n\n";
        $message .= "" . core::getLanguage('str', 'AUTHOR_MSG') . ": " . $name . "\n";
        $message .= "" . core::getLanguage('str', 'MESSAGE') . ": " . preg_replace('/\<[^>]*>/i', '', $msg) . "\n";

        $m = new PHPMailer();
        $m->CharSet = 'utf-8';
        $m->isHTML(false);

        $m->Subject = core::getLanguage('str', 'added_new_comment');
        $m->FromName = $_SERVER["SERVER_NAME"];
        $m->From = "noreply@" . $_SERVER["SERVER_NAME"];
        $m->AddAddress(core::getSetting('email'));
        $m->Body = $message;

        if ($m->Send()) {
            return true;
        } else {
            return false;
        }
    }

    public function checkBanIP($ip)
    {
        $query = "SELECT * FROM " . core::database()->getTableName('ip');
        $result = core::database()->querySQL($query);
        $check = true;

        foreach (core::database()->getColumnArray($result) as $row) {
            if (preg_match("!".preg_quote($row['ip'])."!", $ip)){
                $check = false;
                break;
            }
        }

        return $check;
    }
}